<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class inventario extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'ubicacion',
        'marca',
        'servicio',
        'nombre',
        'riesgo',
        'comercio',
        'modelo',
        'serie',
        'placa',
        'modalidad',
        'subcategoria_id',
    ];
    
    public function subcategorias(): BelongsTo
    {
        return $this->belongsTo(subcategorias::class, 'subcategoria_id');
    }
    public function cronograma(): HasOne
    {
        return $this->hasOne(Cronogramas::class, 'inventario_id', 'id');
    }
    public function archivos(): HasMany
    {
        return $this->HasMany(archivos::class, 'inventario_id', 'id');
    }
}
