<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class Gsubcategorias extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'nombre',
        'color',
        'categoria_id',
    ];

    public function gcategoria()
    {
        return $this->belongsTo(Gcategorias::class, 'categoria_id');
    }
    public function categorias()
    {
        return $this->belongsTo(Gcategorias::class, 'categoria_id');
    }

    public function ginventarios()
    {
        return $this->hasMany(Ginventarios::class, 'subcategoria_id');
    }
}
