<?php

namespace App\Http\Controllers;

use App\Models\Gsubcategorias;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreGsubcategoriasRequest;
use App\Http\Requests\UpdateGsubcategoriasRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class GsubcategoriasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($request)
    {
        if($request == 'all'){
            $subcategorias = Gsubcategorias::all();
        }else{
            $subcategorias = Gsubcategorias::where('categoria_id', $request)->get();
        }
        return response()->json($subcategorias, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGsubcategoriasRequest $request)
    {
        try {
            $subcategoria = new Gsubcategorias();
            $subcategoria->fill($request->all());
            $subcategoria->saveOrFail();
            return response()->json(['message' => 'Categoria agregado exitosamente', 'product' => $subcategoria], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Gsubcategorias $gsubcategoria)
    {
        return response()->json($gsubcategoria, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Gsubcategorias $gsubcategorias)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGsubcategoriasRequest $request, Gsubcategorias $gsubcategoria)
    {
        $gsubcategoria->fill($request->all());
        if ($gsubcategoria->save()) {
            return response()->json(['data' => $gsubcategoria, 'message' => 'La categoria se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $gsubcategoria, 'message' => 'Ha ocurrido un error al actualizar la categoria'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Gsubcategorias $gsubcategoria)
    {
        $gsubcategoria->delete();
        return response()->json(['data' => $gsubcategoria, 'message' => 'La categoria se ha eliminado correctamente'], 200);
    }
}
