<?php

namespace App\Http\Controllers;

use App\Models\Gsedes;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreGsedesRequest;
use App\Http\Requests\UpdateGsedesRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class GsedesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $sedes = Gsedes::all();
        return response()->json($sedes, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGsedesRequest $request)
    {
        try {
            $sede = new Gsedes();
            $sede->fill($request->all());
            $sede->saveOrFail();
            return response()->json(['message' => 'Sede agregado exitosamente', 'product' => $sede], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Gsedes $gsede)
    {
        return response()->json($gsede, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Gsedes $gsedes)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGsedesRequest $request, Gsedes $gsede)
    {
        $gsede->fill($request->all());
        if ($gsede->save()) {
            return response()->json(['data' => $gsede, 'message' => 'La sede se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $gsede, 'message' => 'Ha ocurrido un error al actualizar la sede'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Gsedes $gsede)
    {
        $gsede->delete();
        return response()->json(['data' => $gsede, 'message' => 'La categoria se ha eliminado correctamente'], 200);
    }
}
